/* $Id: Rules.h,v 1.2 2008/04/10 02:35:03 dpt Exp $
 *
 * Rules.h: a class that encapsulates the game logic.
 */

#ifndef __RULES_H__
#define __RULES_H__

#include "GameState.h"
WX_DECLARE_LIST(Question, QueryList);
WX_DECLARE_LIST(DoneSpell, DoneSpellList);


class Rules : public GameState {
 public:
  Rules();
  Rules(const Rules& other);
  Rules& operator=(const Rules& other);
  ~Rules();

  void next_turn();
  void start_game();
  void add_gestures(int id, wxInt8 left, wxInt8 right);
  void start_questions();
  void add_answer(int id, const wxString& question, wxInt32 index);
  void run_turn_events();
  bool is_game_over();
  bool phase_is_done();
  void remove_player(wxUint8 id);

  bool dispel_magic, fire_storm, ice_storm;

 private:
  QueryList* m_questions[ MAX_PLAYERS ];
  wxUint8    m_batch_left[ MAX_PLAYERS ];
  DoneSpellList m_spells;

  void _add_spell(wxUint8 caster, wxUint8 hand, wxUint8 sp_id);
  bool _ask_questions(wxUint8 sp);
  void _ask_extra_questions(int id);
  void _add_elemental_question(int id, wxUint8 sp);
  void _add_new_monster_question(int id, wxUint8 sp);
  void _add_monster_question(int id, wxUint8 monster);
  void _add_target_question(int id, int hand, wxUint8 sp);
  void _add_charm_question(int id, wxUint8 sp);
  void _add_hand_question(int id, wxUint8 sp);
  void _add_spell_question(int id, PossibleSpellList* list, int hand,
			    bool or_both = false);
  void _add_question(int id, Question* q, bool important = false);
  void _process_end_of_turn_events();
  void _run_spell(int id, int hand);
  void _send_waiting_events();
  void _sanity_check() const;
  void _send_turn() const;
  void _send_gestures(bool replace = false, int id = -1) const;
  void _msg(int you, const Event& smsg) const;
  void _msg(int you, const Event& smsg, const Event& omsg) const;
  void _msg(int you, const Event& smsg, const Event& omsg,
	     int target, const Event& tmsg) const;
  int  _random_being(unsigned int c);
  void _exec_counters(int i);
  void _exec_illness();
  void _exec_all_spells();
  void _exec_elements();
  void _exec_summons(int i);
  void _exec_cancels(int i);
  void _exec_protects(int i);
  void _exec_enchants(int i);
  void _exec_attacks(int i);
  void _exec_heals(int i);
  void _exec_monsters();
  void _exec_monster_attack(int target, int attacker);
  void _create_monster(unsigned int owner, wxUint8 type, wxInt8 target = -1);
  bool _check_visibility(DoneSpell* sp);
  DoneSpell* _find_spell(int target, int spell);
  int _find_duration(int target, int spell);
  void _remove_permanency(int id);
  void _remove_delayed_effect(int id);
};


#endif   // __RULES_H__
