// R_Spells.cpp: This file is way the hell too long.

#include "Spellcast.h"
#include "Messages.h"


static int mind_spells[ NUMBER_OF_MIND_SPELLS ] = {
  SPELL_AMNESIA, SPELL_CONFUSION, SPELL_CHARM_PERSON, SPELL_CHARM_MONSTER,
  SPELL_FEAR, SPELL_PARALYSIS
};

static int mind_durations[ NUMBER_OF_MIND_SPELLS ] = {
  D_AMNESIA, D_CONFUSION, D_CHARM_PERSON, NO_DURATION, D_FEAR, D_PARALYSIS
};


// Elementals are handled separately from the other monsters.
void Rules::_exec_summons(int i) {
  static int monster_spells[ 4 ] = {
    SPELL_SUMMON_GOBLIN, SPELL_SUMMON_OGRE, SPELL_SUMMON_TROLL, SPELL_SUMMON_GIANT
  };
  static int monsters[ 4 ] = {
    CREATURE_GOBLIN, CREATURE_OGRE, CREATURE_TROLL, CREATURE_GIANT
  };
  Player* p = player(i);
  wxASSERT(p != NULL);

  for (unsigned int x = 0 ; x < 4 ; x++) {
    unsigned int howmany = p->zaps(monster_spells[x]);
    if (howmany) {
      _msg(i, msg_s_summon_monsters(monsters[x], howmany),
	   msg_o_summon_monsters(p, monsters[x], howmany));
      for (unsigned int y = 0 ; y < howmany ; y++) {
	DoneSpell* sp = _find_spell(i, monster_spells[x]);
	for (unsigned int i = 0; i < p->zaps(monster_spells[x]); i++) {
	  _create_monster(sp->caster, monsters[x], sp->detail);
	}
      }
    }
  }

  for (DoneSpellList::Node* node = m_spells.GetFirst() ; node != NULL ; node = node->GetNext()) { 
    DoneSpell* sp = node->GetData();
    if (sp->caster == i && sp->id == SPELL_SUMMON_ELEMENTAL) {
      switch (sp->detail) {
      case CREATURE_FIRE_EL:
	_msg(i, msg_s_summon_fire_el(), msg_o_summon_fire_el(p));  break;
      case CREATURE_ICE_EL:
	_msg(i, msg_s_summon_ice_el(), msg_o_summon_ice_el(p));    break;
      default: FAIL();
      }
      _create_monster(i, sp->detail);
    }
  }
}


void Rules::_exec_elements() {
  int num_fire = 0, num_ice = 0;
  Creature* fire = NULL;
  Creature* ice = NULL;

  for (unsigned int i = 0 ; i < m_max_creatures ; i++) {
    Creature* c = creature(i);
    if (c && c->is_alive()) {
      if (c->type() == CREATURE_FIRE_EL) {
	num_fire++;
	if (num_fire == 1) {
	  fire = c;
	} else {
	  fire->heal(999);
	  c->destroy_corpse();
	  c->make_dead();
	}
      } else if (c->type() == CREATURE_ICE_EL) {
	num_ice++;
	if (num_ice == 1) {
	  ice = c;
	} else {
	  ice->heal(999);
	  c->destroy_corpse();
	  c->make_dead();
	}
      }
    }
  }

  if (num_fire > 1) {
    g_server->broadcast(msg_a_elementals_merge(CREATURE_FIRE_EL, num_fire));
  }

  if (num_ice > 1) {
    g_server->broadcast(msg_a_elementals_merge(CREATURE_ICE_EL, num_ice));
  }

  // This clever bit was Andrew Plotkin's doing, not mine.
  int foo = (num_fire > 0 ? 1 : 0) | (num_ice > 0 ? 2 : 0) |
            (fire_storm ? 4 : 0)   | (ice_storm ? 8 : 0);
  switch (foo) {
  case 3:   // 0011
    g_server->broadcast(msg_a_elementals_fight());
    fire->destroy_corpse();
    ice->destroy_corpse();
    fire->make_dead();
    ice->make_dead();
    break;

  case 5:   // 0101
    g_server->broadcast(msg_a_elemental_storm_1(CREATURE_FIRE_EL, SPELL_FIRE_STORM));
    fire->destroy_corpse();
    fire->make_dead();
    break;

  case 6:   // 0110
    g_server->broadcast(msg_a_elemental_storm_2(CREATURE_ICE_EL, SPELL_FIRE_STORM));
    fire_storm = false;
    ice->destroy_corpse();
    ice->make_dead();
    break;

  case 7:   // 0111
    g_server->broadcast(msg_a_elementals_kill_storm(SPELL_FIRE_STORM));
    fire_storm = false;
    fire->destroy_corpse();
    ice->destroy_corpse();
    fire->make_dead();
    ice->make_dead();
    break;

  case 9:   // 1001
    g_server->broadcast(msg_a_elemental_storm_2(CREATURE_FIRE_EL, SPELL_ICE_STORM));
    ice_storm = false;
    fire->destroy_corpse();
    fire->make_dead();
    break;

  case 10:   // 1010
    g_server->broadcast(msg_a_elemental_storm_1(CREATURE_ICE_EL, SPELL_ICE_STORM));
    ice_storm = false;
    ice->destroy_corpse();
    ice->make_dead();
    break;

  case 11:   // 1011
    g_server->broadcast(msg_a_elementals_kill_storm(SPELL_ICE_STORM));
    ice_storm = false;
    fire->destroy_corpse();
    ice->destroy_corpse();
    fire->make_dead();
    ice->make_dead();
    break;

  case 12:   // 1100
    g_server->broadcast(msg_a_storms_fight());
    fire_storm = false;
    ice_storm = false;
    break;

  case 13:   // 1101
    g_server->broadcast(msg_a_storms_kill_elemental(CREATURE_FIRE_EL));
    fire_storm = false;
    ice_storm = false;
    fire->destroy_corpse();
    fire->make_dead();
    break;

  case 14:   // 1110
    g_server->broadcast(msg_a_storms_kill_elemental(CREATURE_ICE_EL));
    fire_storm = false;
    ice_storm = false;
    ice->destroy_corpse();
    ice->make_dead();
    break;

  case 15:   // 1110
    g_server->broadcast(msg_a_storms_and_elementals());
    fire_storm = false;
    ice_storm = false;
    fire->destroy_corpse();
    ice->destroy_corpse();
    fire->make_dead();
    ice->make_dead();
    break;
  }

  for (unsigned int i = 0 ; i < m_max_creatures ; i++) {
    Creature* c = creature(i);
    int dead = 0;
    if (c && c->is_alive()) {
      if (c->type() == CREATURE_FIRE_EL && c->zaps(SPELL_RESIST_HEAT)) {
	g_server->broadcast(msg_a_fire_el_resisted(c));
	dead = 1;
      } else if (c->type() == CREATURE_ICE_EL) {
	if (c->zaps(SPELL_RESIST_COLD)) {
	  g_server->broadcast(msg_a_ice_el_resisted(c));
	  dead = 1;
	} else if (c->zaps(SPELL_FIREBALL)) {
	  g_server->broadcast(msg_a_ice_el_fireballed(c));
	  dead = 1;
	}
      }

      if (!dead && c->zaps(SPELL_BLINDNESS)) {
	g_server->broadcast(msg_a_spell_stress(c, SPELL_BLINDNESS));
	dead = 1;
      } else if (!dead && c->zaps(SPELL_INVISIBILITY)) {
	g_server->broadcast(msg_a_spell_stress(c, SPELL_INVISIBILITY));
	dead = 1;
      }

      if (dead) {
	c->destroy_corpse();
	c->make_dead();
      }

      if (c->is_alive() && c->zaps(SPELL_REMOVE_ENCHANTMENT)) {
	g_server->broadcast(msg_a_rmench_stress(c));
	c->destroy_corpse();
	c->hurt(999);
      }
    }
  }
}


void Rules::_exec_cancels(int i) {
  int mindlist[ NUMBER_OF_MIND_SPELLS ];
  Being* b = being(i);
  wxASSERT(b != NULL);

  if (b->zaps(SPELL_RAISE_DEAD) && b->zaps(SPELL_FINGER_OF_DEATH)) {
    _msg(i, msg_s_fod_raise_cancel(), msg_o_fod_raise_cancel(b));
    b->set_zap(SPELL_FINGER_OF_DEATH, 0);
    b->set_zap(SPELL_RAISE_DEAD, 0);
  }

  if (b->zaps(SPELL_FIREBALL) && ice_storm) {
    _msg(i, msg_s_fb_storm_cancel(), msg_o_fb_storm_cancel(b));
    b->set_zap(SPELL_FIREBALL, 0);
    b->set_ice_storm_immune();
  }

  int n_spells = 0, done = 0;
  for (unsigned int x = 0 ; x < NUMBER_OF_MIND_SPELLS ; x++) {
    if (b->zaps(mind_spells[x])) {
      for (unsigned int y = 0 ; y < NUMBER_OF_MIND_SPELLS ; y++) {
	if (b->duration(mind_durations[y]) == DURATION_PERMANENT) {
	  _msg(i, msg_s_perm_mind_cancel(mind_spells[x], mind_spells[y]),
	       msg_o_perm_mind_cancel(b, mind_spells[x], mind_spells[y]));
	  b->set_zap(mind_spells[x], 0);
	  done = 1;
	}
      }
      if (!done) {
	for (unsigned int y = 0 ; y < b->zaps(mind_spells[x]) ; y++) {
	  mindlist[ n_spells++ ] = mind_spells[x];
	}
      }
    }
  }

  if (n_spells > 1) {
    _msg(i, msg_s_mind_cancel(mindlist, n_spells), msg_o_mind_cancel(b, mindlist, n_spells));
    for (unsigned int x = 0 ; x < NUMBER_OF_MIND_SPELLS ; x++) {
      b->set_zap(mind_spells[x], 0);
    }
  }
}


void Rules::_exec_protects(int i) {
  Being* b = being(i);
  wxASSERT(b != NULL);

  if (b->zaps(SPELL_RESIST_HEAT)) {
    if (b->duration(D_RESIST_HEAT) == 0) {
      _msg(i, msg_s_got_resist_heat(), msg_o_got_resist_heat(b));
      b->set_duration(D_RESIST_HEAT, _find_duration(i, SPELL_RESIST_HEAT));
    } else {
      _msg(i, msg_s_more_resist_heat(), msg_o_more_resist_heat(b));
    }
  }

  if (b->zaps(SPELL_RESIST_COLD)) {
    if (b->duration(D_RESIST_COLD) == 0) {
      _msg(i, msg_s_got_resist_cold(), msg_o_got_resist_cold(b));
      b->set_duration(D_RESIST_COLD, _find_duration(i, SPELL_RESIST_COLD));
    } else {
      _msg(i, msg_s_more_resist_cold(), msg_o_more_resist_cold(b));
    }
  }

  if (b->zaps(SPELL_PROTECTION_FROM_EVIL) ||
      b->duration(D_PROTECTION) == DURATION_PERMANENT) {
    if (b->duration(D_PROTECTION) == 0) {
      _msg(i, msg_s_got_prot_evil(), msg_o_got_prot_evil(b));
      b->set_duration(D_PROTECTION, _find_duration(i, SPELL_PROTECTION_FROM_EVIL));
    } else {
      _msg(i, msg_s_more_prot_evil(), msg_o_more_prot_evil(b));
    }
  }

  if ((m_turn_type != TURN_TIMESTOP || b->duration(D_TIMESTOP))) {
    if (b->duration(D_PROTECTION)) {
      switch (b->duration(D_PROTECTION)) {
      case 3:
	_msg(i, msg_s_fade_prot_evil_3(), msg_o_fade_prot_evil_3(b));
	break;
      case 2:
	_msg(i, msg_s_fade_prot_evil_2(), msg_o_fade_prot_evil_2(b));
	break;
      case 1:
	_msg(i, msg_s_fade_prot_evil_1(), msg_o_fade_prot_evil_1(b));
	break;
      }
      b->set_zap(SPELL_SHIELD, b->zaps(SPELL_SHIELD) + 64);
    }
  }
}


DoneSpell* Rules::_find_spell(int target, int spell) {
  for (DoneSpellList::Node* node = m_spells.GetFirst() ; node != NULL ; node = node->GetNext()) {
    DoneSpell* sp = node->GetData();
    if (sp->target == target && sp->id == spell) {
      return sp;
    }
  }
  return NULL;
}


int Rules::_find_duration(int target, int spell) {
  DoneSpell* sp = _find_spell(target, spell);
  if (sp->permanent) return DURATION_PERMANENT;
  return spell_list[ sp->id ].duration;
}


void Rules::_exec_enchants(int i) {
  static int list[ 4 ] = { SPELL_AMNESIA, SPELL_CONFUSION, SPELL_FEAR, SPELL_PARALYSIS };
  static int durations[ 4 ] = { D_AMNESIA, D_CONFUSION, D_FEAR, D_PARALYSIS };
  Being* b = being(i);
  wxASSERT(b != NULL);

  for (unsigned int x = 0 ; x < NUMBER_OF_MIND_SPELLS ; x++) {
    if (b->duration(mind_durations[x]) == DURATION_PERMANENT) {
      switch (mind_spells[x]) {
      case SPELL_AMNESIA:
      case SPELL_CONFUSION:
      case SPELL_FEAR:
	_msg(i, msg_s_mind_afflicted(mind_spells[x]), msg_o_mind_afflicted(b, mind_spells[x]));
	break;

      case SPELL_CHARM_MONSTER: {
	Creature* c = creature(i - MAX_PLAYERS);
	c->set_owner(b->mind_detail);
	g_server->broadcast(msg_a_charmed_still(c, being(b->mind_detail)));
      } break;

      case SPELL_CHARM_PERSON:
	_msg(i, msg_s_charmed_still(), msg_o_charmed_still(b));
	break;

      case SPELL_PARALYSIS:
	if (i < (int) MAX_PLAYERS) {
	  _msg(i, msg_s_paralyzed_still(b->mind_hand), msg_o_paralyzed_still(b, b->mind_hand));
	} else {
	  g_server->broadcast(msg_a_paralyzed_still((Creature*) b));
	}
	break;

      default: FAIL();
      }
    }
  }

  for (unsigned int x = 0 ; x < 4 ; x++) {
    if (b->zaps(list[x])) {
      DoneSpell* sp = _find_spell(i, list[x]);
      wxASSERT(sp != NULL);
      b->set_duration(durations[x], _find_duration(i, list[x]));
      _msg(i, msg_s_mind_curl(list[x]), msg_o_mind_curl(b, list[x]));
      b->mind_hand = sp->mind_hand - 1;
    }
  }

  if (b->zaps(SPELL_CHARM_MONSTER)) {
    if (i < (int) MAX_PLAYERS) {
      _msg(i, msg_s_mind_fail(SPELL_CHARM_MONSTER), msg_o_mind_fail(b, SPELL_CHARM_MONSTER));
      b->set_zap(SPELL_CHARM_MONSTER, 0);

    } else {
      DoneSpell* sp = _find_spell(i, SPELL_CHARM_MONSTER);
      wxASSERT(player(sp->caster) != NULL);
      if (sp->permanent) {
	b->set_duration(D_CHARM_MONSTER, DURATION_PERMANENT);
      }
      g_server->broadcast(msg_a_charm_monster(player(sp->caster), b));
      creature(i - MAX_PLAYERS)->set_owner(sp->caster);
    }
  }

  if (b->zaps(SPELL_CHARM_PERSON)) {
    if (i < (int) MAX_PLAYERS) {
      DoneSpell* sp = _find_spell(i, SPELL_CHARM_PERSON);
      wxASSERT(player(sp->caster) != NULL);
      _msg(i, msg_s_hand_curl(SPELL_CHARM_PERSON, sp->mind_hand),
	    msg_o_hand_curl(b, SPELL_CHARM_PERSON, sp->mind_hand));
      b->set_duration(D_CHARM_PERSON, _find_duration(i, SPELL_CHARM_PERSON));
      wxASSERT(sp->mind_hand > 0);
      b->mind_hand = sp->mind_hand - 1;
      b->mind_detail = sp->detail;

    } else {
      g_server->broadcast(msg_o_mind_fail(b, SPELL_CHARM_PERSON));
      b->set_zap(SPELL_CHARM_PERSON, 0);
    }
  }

  if (b->zaps(SPELL_DISEASE)) {
    b->set_duration(D_DISEASE, spell_list[ SPELL_DISEASE ].duration);
  }

  if (b->zaps(SPELL_POISON)) {
    b->set_duration(D_POISON, spell_list[ SPELL_POISON ].duration);
  }

  if (b->zaps(SPELL_ANTI_SPELL)) {
    if (b->zaps(SPELL_REMOVE_ENCHANTMENT)) {
      _msg(i, msg_s_anti_rmench_cancel(), msg_o_anti_rmench_cancel(b));
    } else if (i < (int) MAX_PLAYERS) {
      _msg(i, msg_s_antispell_hit(), msg_o_antispell_hit(b));
      add_gestures(i, GESTURE_ANTISPELL, GESTURE_ANTISPELL);
      _send_gestures(false, i);
    } else {
      g_server->broadcast(msg_a_antispell_miss(b));
    }
  }

  if (b->zaps(SPELL_DELAYED_EFFECT)) {
    if (b->zaps(SPELL_REMOVE_ENCHANTMENT)) {
      _msg(i, msg_s_delay_rmench_cancel(), msg_o_delay_rmench_cancel(b));
    } else if (i < (int) MAX_PLAYERS) {
      _msg(i, msg_s_delay_hit(), msg_o_delay_hit(b));
      b->set_duration(D_DELAYED_EFFECT, spell_list[ SPELL_DELAYED_EFFECT ].duration);
    } else {
      g_server->broadcast(msg_a_delay_miss(b));
    }
  }

  if (b->zaps(SPELL_PERMANENCY)) {
    if (b->zaps(SPELL_REMOVE_ENCHANTMENT)) {
      _msg(i, msg_s_perm_rmench_cancel(), msg_o_perm_rmench_cancel(b));
    } else if (i < (int) MAX_PLAYERS) {
      _msg(i, msg_s_perm_hit(), msg_o_perm_hit(b));
      b->set_duration(D_PERMANENCY, spell_list[ SPELL_PERMANENCY ].duration);
    } else {
      g_server->broadcast(msg_a_perm_miss(b));
    }
  }

  if (b->zaps(SPELL_BLINDNESS)) {
    _msg(i, msg_s_blind_hit(), msg_o_blind_hit(b));
    b->set_duration(D_BLINDNESS, _find_duration(i, SPELL_BLINDNESS));
  }

  if (b->zaps(SPELL_INVISIBILITY)) {
    _msg(i, msg_s_invis_hit(), msg_o_invis_hit(b));
    b->set_duration(D_INVISIBILITY, _find_duration(i, SPELL_INVISIBILITY));
  }

  if (b->zaps(SPELL_HASTE) || b->duration(D_HASTE) == DURATION_PERMANENT) {
    if (b->duration(D_HASTE)) {
      b->age_duration(D_HASTE);
    } else {
      b->set_duration(D_HASTE, _find_duration(i, SPELL_HASTE));
    }
  }

  if (b->zaps(SPELL_TIME_STOP)) {
    b->set_duration(D_TIMESTOP, _find_duration(i, SPELL_TIME_STOP));
  }

  if (b->zaps(SPELL_REMOVE_ENCHANTMENT) || dispel_magic) {
    if (b->zaps(SPELL_REMOVE_ENCHANTMENT)) {
      _msg(i, msg_s_rmench_hit(), msg_o_rmench_hit(b));
    }

    for (unsigned int x = 0 ; x < NUMBER_OF_MIND_SPELLS ; x++) {
      if (b->duration(mind_durations[x])) {
	b->set_duration(mind_durations[x], 0);
	_msg(i, msg_s_dispel_mind(mind_spells[x]), msg_o_dispel_mind(b, mind_spells[x]));
      }
    }

    if (b->duration(D_RESIST_HEAT)) {
      b->set_duration(D_RESIST_HEAT, 0);
      _msg(i, msg_s_dispel_heat(), msg_o_dispel_heat(b));
    }

    if (b->duration(D_RESIST_COLD)) {
      b->set_duration(D_RESIST_COLD, 0);
      _msg(i, msg_s_dispel_cold(), msg_o_dispel_cold(b));
    }

    if (b->duration(D_DISEASE)) {
      b->set_duration(D_DISEASE, 0);
      _msg(i, msg_s_dispel_disease(), msg_o_dispel_disease(b));
    }

    if (b->duration(D_POISON)) {
      b->set_duration(D_POISON, 0);
      _msg(i, msg_s_dispel_poison(), msg_o_dispel_poison(b));
    }

    if (i < (int) MAX_PLAYERS) {
      if (b->duration(D_DELAYED_EFFECT)) {
	b->set_duration(D_DELAYED_EFFECT, 0);
	_msg(i, msg_s_dispel_delay(), msg_o_dispel_delay(b));
      }

      if (b->duration(D_PERMANENCY)) {
	b->set_duration(D_PERMANENCY, 0);
	_msg(i, msg_s_dispel_perm(), msg_o_dispel_perm(b));
      }

      Player* p = player(i);
      if (p->banked() >= 0) {
	_msg(i, msg_s_dispel_stored(p), msg_o_dispel_stored(p));
	p->set_banked(-1);
      }
    }

    if (b->duration(D_PROTECTION)) {
      b->set_duration(D_PROTECTION, 0);
      _msg(i, msg_s_dispel_prot(), msg_o_dispel_prot(b));
    }

    if (b->zaps(SPELL_SHIELD) >= 64) {
      b->set_zap(SPELL_SHIELD, b->zaps(SPELL_SHIELD) % 64);
    }

    switch (b->duration(D_HASTE)) {
    case 0:  break;
    case 4:
      _msg(i, msg_s_cancel_haste(), msg_o_cancel_haste(b));
      b->set_duration(D_HASTE, 0);
      break;

    default:
      _msg(i, msg_s_dispel_haste(), msg_o_dispel_haste(b));
      b->set_duration(D_HASTE, 0);
      break;
    }

    if (b->duration(D_TIMESTOP)) {
      b->set_duration(D_TIMESTOP, 0);
      _msg(i, msg_s_cancel_timestop(), msg_o_cancel_timestop(b));
    }

    if (b->duration(D_INVISIBILITY)) {
      b->set_duration(D_INVISIBILITY, 0);
      _msg(i, msg_s_dispel_invis(), msg_o_dispel_invis(b));
    }

    if (b->duration(D_BLINDNESS)) {
      b->set_duration(D_BLINDNESS, 0);
      _msg(i, msg_s_dispel_blind(), msg_o_dispel_blind(b));
    }

  } else {  // normal effect, not removed or dispelled

    if (b->duration(D_INVISIBILITY) && !dispel_magic) {
      switch (b->duration(D_INVISIBILITY)) {
      case 4:  break;
      case 1:  _msg(i, msg_s_invis_fades(), msg_o_invis_fades(b)); break;
      default: _msg(i, msg_s_invis_still(), msg_o_invis_still(b)); break;
      }
    }

    if (b->duration(D_BLINDNESS)) {
      switch (b->duration(D_BLINDNESS)) {
      case 4:  break;
      case 1:  _msg(i, msg_s_blind_fades(), msg_o_blind_fades(b)); break;
      default: _msg(i, msg_s_blind_still(), msg_o_blind_still(b)); break;
      }
    }
  }
}


void Rules::_exec_attacks(int i) {
  Being* b = being(i);
  wxASSERT(b != NULL);

  if (b->zaps(SPELL_STAB)) {
    int n = b->zaps(SPELL_STAB);
    if (b->zaps(SPELL_SHIELD)) {
      _msg(i, msg_s_stabs_miss(n), msg_o_stabs_miss(b, n));
    } else {
      _msg(i, msg_s_stabs_hit(n), msg_o_stabs_hit(b, n));
      b->hurt(n);
    }
  }

  if (b->zaps(SPELL_MISSILE)) {
    int n = b->zaps(SPELL_MISSILE);
    if (b->zaps(SPELL_SHIELD)) {
      _msg(i, msg_s_missiles_miss(n), msg_o_missiles_miss(b, n));
    } else {
      _msg(i, msg_s_missiles_hit(n), msg_o_missiles_hit(b, n));
      b->hurt(n);
    }
  }

  if (b->zaps(SPELL_CAUSE_LIGHT_WOUNDS)) {
    int n = b->zaps(SPELL_CAUSE_LIGHT_WOUNDS);
    _msg(i, msg_s_cause_light_hit(n), msg_o_cause_light_hit(b, n));
    b->hurt(n * 2);
  }

  if (b->zaps(SPELL_CAUSE_HEAVY_WOUNDS)) {
    int n = b->zaps(SPELL_CAUSE_HEAVY_WOUNDS);
    _msg(i, msg_s_cause_heavy_hit(n), msg_o_cause_heavy_hit(b, n));
    b->hurt(n * 3);
  }

  if (b->zaps(SPELL_LIGHTNING_BOLT)) {
    int n = b->zaps(SPELL_LIGHTNING_BOLT);
    _msg(i, msg_s_lightning_hit(n), msg_o_lightning_hit(b, n));
    b->hurt(n * 5);
  }

  if (b->zaps(SPELL_FIREBALL)) {
    int n = b->zaps(SPELL_FIREBALL);
    if (b->duration(D_RESIST_HEAT)) {
      _msg(i, msg_s_fireball_resist(n), msg_o_fireball_resist(b, n));
    } else {
      _msg(i, msg_s_fireball_hit(n), msg_o_fireball_hit(b, n));
      b->hurt(n * 5);
    }
  }

  if (fire_storm) {
    if (b->zaps(SPELL_COUNTER_SPELL)) {
      _msg(i, msg_s_counter_storm(SPELL_FIRE_STORM), msg_o_counter_storm(b, SPELL_FIRE_STORM));
    } else if (b->duration(D_RESIST_HEAT) &&
	       (m_turn_type != TURN_TIMESTOP || b->duration(D_TIMESTOP))) {
      _msg(i, msg_s_fire_storm_resist(), msg_o_fire_storm_resist(b));
    } else {
      _msg(i, msg_s_storm_hit(SPELL_FIRE_STORM), msg_o_storm_hit(b, SPELL_FIRE_STORM));
      b->hurt(5);
    }
  }

  if (ice_storm) {
    if (b->zaps(SPELL_COUNTER_SPELL)) {
      _msg(i, msg_s_counter_storm(SPELL_ICE_STORM), msg_o_counter_storm(b, SPELL_ICE_STORM));
    } else if (b->duration(D_RESIST_COLD) &&
	       (m_turn_type != TURN_TIMESTOP || b->duration(D_TIMESTOP))) {
      _msg(i, msg_s_ice_storm_resist(), msg_o_ice_storm_resist(b));
    } else if (b->ice_storm_immune() == false) {
      _msg(i, msg_s_storm_hit(SPELL_ICE_STORM), msg_o_storm_hit(b, SPELL_ICE_STORM));
      b->hurt(5);
    }
  }

  if (b->zaps(SPELL_FINGER_OF_DEATH)) {
    _msg(i, msg_s_fod_hit(), msg_o_fod_hit(b));
    b->hurt(999);   /// ouch...
  }
}


void Rules::_exec_heals(int i) {
  Being* b = being(i);
  wxASSERT(b != NULL);

  if (b->is_alive()) {
    int orig_hp = b->health();

    if (b->zaps(SPELL_CURE_LIGHT_WOUNDS)) {
      int n = b->zaps(SPELL_CURE_LIGHT_WOUNDS);
      _msg(i, msg_s_cure_light(n), msg_o_cure_light(b, n));
      b->heal(n);
    }

    if (b->zaps(SPELL_CURE_HEAVY_WOUNDS)) {
      int n = b->zaps(SPELL_CURE_HEAVY_WOUNDS);
      _msg(i, msg_s_cure_heavy(n), msg_o_cure_heavy(b, n));
      b->heal(n * 2);

      if (b->duration(D_DISEASE)) {
	b->set_duration(D_DISEASE, 0);
	_msg(i, msg_s_dispel_disease(), msg_o_dispel_disease(b));
      }
    }

    if (b->zaps(SPELL_RAISE_DEAD)) {
      int n = b->zaps(SPELL_RAISE_DEAD);
      _msg(i, msg_s_raise_alive(n), msg_o_raise_alive(b, n));
      b->heal(n * 5);

      if (b->duration(D_DISEASE)) {
	b->set_duration(D_DISEASE, 0);
	_msg(i, msg_s_dispel_disease(), msg_o_dispel_disease(b));
      }
    }

    if (b->health() > b->max_health() ||
	(b->health() == b->max_health() && b->health() != orig_hp)) {
      if (!b->duration(D_DISEASE) && !b->duration(D_POISON)) {
	_msg(i, msg_s_all_healed(), msg_o_all_healed(b));
      }
      b->hurt(b->health() - b->max_health());
    }

  } else {
    if (b->zaps(SPELL_RAISE_DEAD)) {
      wxASSERT(b->raiseable());
      _msg(i, msg_s_raise_dead(), msg_o_raise_dead(b));
      b->make_alive();
      b->heal(b->max_health() - b->health());
      for (unsigned int x = 0 ; x < NUMBER_OF_DURATION_ENTRIES ; x++) {
	b->set_duration(x, 0);
      }
      if (i < (int) MAX_PLAYERS) {
	player(i)->set_banked(-1);
      } else {
	Creature* c = creature(i - MAX_PLAYERS);
	c->undestroy_corpse();   // this is useless, right?
	c->set_owner(_find_spell(i, SPELL_RAISE_DEAD)->caster);
      }
    }
  }

  if (b->health() < 0) {
    b->heal(abs(b->health()));
  }
}
