// MemBuf.h: Because wxMemoryBuffer has such a poor interface. (Also
// because I cannot seem to stop typing "wxMemoryBugger".)

#ifndef __MEMBUF_H__
#define __MEMBUF_H__

#include <wx/wx.h>
#include <wx/config.h>


class MemBuf : public wxMemoryBuffer {
 public:
  static const size_t ALL = 4294967295UL;

  MemBuf(size_t bytes = wxMemoryBufferData::DefBufSize);
  MemBuf(const wxString& str);
  wxUint8 operator[](size_t index);
  inline wxUint8* operator*() const { return (wxUint8*) GetData(); }

  void trim_start(size_t bytes);
  void trim_end(size_t bytes);
  void prepend(const wxUint8* input, size_t bytes);
  void append(const wxUint8* input, size_t bytes);
  void append(const wxString& str);
  void append(const MemBuf& buf);
  void append(unsigned char ch);
  wxString as_str(size_t start = 0, size_t len = ALL) const;
  inline void clear() { SetDataLen(0); }
  inline size_t length() const { return GetDataLen(); }
  inline wxUint8* data() const { return (wxUint8*) GetData(); }
  inline bool is_empty() const { return length() == 0; }
  MemBuf subset(size_t start, size_t len = ALL) const;
  void dump() const;
};


#endif   // __MEMBUF_H__
