/* $Id: Images.h,v 1.1.1.1 2008/02/25 12:26:54 dpt Exp $
 *
 * Images.h: Loading and storing bitmap images.
 */

#ifndef __IMAGES_H__
#define __IMAGES_H__

#include "Util.h"


enum image_list {
  NO_GESTURE,
  ANTISPELL_GESTURE,
  UNKNOWN_GESTURE,
  BIG_HAND_LEFT_CLAP,
  BIG_HAND_LEFT_DIGIT,
  BIG_HAND_LEFT_FINGERS,
  BIG_HAND_LEFT_KNIFE,
  BIG_HAND_LEFT_PALM,
  BIG_HAND_LEFT_SNAP,
  BIG_HAND_LEFT_WAVE,
  BIG_HAND_RIGHT_CLAP,
  BIG_HAND_RIGHT_DIGIT,
  BIG_HAND_RIGHT_FINGERS,
  BIG_HAND_RIGHT_KNIFE,
  BIG_HAND_RIGHT_PALM,
  BIG_HAND_RIGHT_SNAP,
  BIG_HAND_RIGHT_WAVE,
  SMALL_CLAP,
  SMALL_DIGIT,
  SMALL_DOUBLE_DIGIT,
  SMALL_FINGERS,
  SMALL_DOUBLE_FINGERS,
  SMALL_PALM,
  SMALL_DOUBLE_PALM,
  SMALL_SNAP,
  SMALL_DOUBLE_SNAP,
  SMALL_WAVE,
  SMALL_DOUBLE_WAVE,
  SPELL_LIST,
  NUMBER_OF_IMAGES
};


class Images {
 public:
  Images();
  ~Images();

  wxBitmap* get_image(int which) const;
  wxBitmap get_gesture_image(int hand, int gesture) const;
  wxIcon get_icon() const;

 private:
  wxBitmap* bitmaps;
};


#endif   // __IMAGES_H__
