// GameState.h: a class which contains all of the current game's data.

#ifndef __GAMESTATE_H__
#define __GAMESTATE_H__

#include "GameData.h"


enum turn_types {
  TURN_NORMAL,
  TURN_HASTED,
  TURN_TIMESTOP,
  NUMBER_OF_TURN_TYPES
};

class GameState;

#define DEFINE_ITERATOR(name)			\
  class name ## Iterator {			\
   public:					\
    name ## Iterator(const GameState* state);	\
    name * operator*() const;			\
    const name ## Iterator& operator++();	\
    name ## Iterator operator++(int postfix);	\
    bool done() const;				\
   private:					\
    GameState* m_state;				\
    wxUint32 m_pos;				\
  };

DEFINE_ITERATOR(Player);
DEFINE_ITERATOR(Creature);
DEFINE_ITERATOR(Being);


class GameState {
 public:
  GameState();
  GameState(const GameState& other);
  GameState(MemBuf* data, wxInt8 me = -1);
  GameState& operator=(const GameState& f);
  ~GameState();
 
  inline wxUint8 player_count() const { return m_player_count; }
  inline wxUint32 creature_count() const { return m_creature_count; }
  inline wxUint32 being_count() const { return m_creature_count + m_player_count; }
  inline PlayerIterator players_iter() const { return PlayerIterator(this); }
  inline CreatureIterator creatures_iter() const { return CreatureIterator(this); }
  inline BeingIterator beings_iter() const { return BeingIterator(this); }
  inline wxUint8 max_players() const { return m_max_players; }
  inline wxUint32 creature_array_size() const { return m_max_creatures; }
  inline wxUint8 game_state() const { return m_game_state; }
  inline wxUint8 phase() const { return m_phase; }
  inline const wxString& server_name() const { return m_server_name; }
  inline wxUint16 server_port() const { return m_server_port; }
  inline wxUint16 turn() const { return m_turn; }
  inline void set_phase(wxUint8 phase)
    { wxASSERT(phase < NUMBER_OF_TURN_PHASES); m_phase = phase; }
  inline Player* player(wxUint8 i) const
    { wxASSERT(i < MAX_PLAYERS); return m_players[i]; }
  inline Creature* creature(wxUint32 i) const
    { wxASSERT(i < m_max_creatures); return m_creatures[i]; }

  MemBuf serialize() const;
  // const GameInfo& get_info() const;
  Player* me() const;
  Being* being(wxUint32 i) const;
  void add_player(wxUint8 id, const wxString& name, wxUint8 gender);
  void add_player(wxUint8 id, Player* player);
  void replace_player(wxUint8 id, Player* p);
  void remove_player(wxUint8 id);
  void add_creature(Creature* thing);
  void remove_creature(wxUint32 id);
  void set_max_players(wxUint8 max_players);
  void set_game_state(wxUint8 new_state);
  void set_server_name(const wxString& name);
  void set_server_port(wxUint16 port);
  void set_done_players(wxUint32 vec);
  bool name_is_taken(const wxString& name) const;

 protected:
  void _clear_everything();

  wxUint8    m_player_count;
  wxUint8    m_max_players;
  wxUint32   m_creature_count;
  wxUint32   m_max_creatures;
  wxUint8    m_game_state;
  wxUint8    m_phase;
  wxUint8    m_turn_type;
  wxString   m_server_name;
  wxUint16   m_server_port;
  wxUint32   m_turn;
  Player*    m_players[ MAX_PLAYERS ];
  Creature** m_creatures;
};


#define MAX_BEINGS  (MAX_PLAYERS + m_max_creatures)


#endif   // __GAMESTATE_H__
