// Event.cpp: Packets of information exchanged by the clients and server.

#include "GameState.h"


const char* event_type_list[ NUMBER_OF_EVENT_TYPES ] = {
  "EVENT_BOGUS",
  "EVENT_ERROR",
  "EVENT_CHAT",
  "EVENT_NAME",
  "EVENT_WELCOME",
  "EVENT_JOIN",
  "EVENT_LEAVE",
  "EVENT_NEWTURN",
  "EVENT_GAMEOVER",
  "EVENT_MSG",
  "EVENT_WAITING",
  "EVENT_CL_HANDS",
  "EVENT_SV_HANDS",
  "EVENT_QUESTION",
  "EVENT_ANSWER",
};


Event::Event() {
  *this = Event(EVENT_BOGUS, 0, wxT(""));
}


Event::Event(wxInt32 type, wxInt32 arg1, const MemBuf& data, wxInt8 arg2, wxInt8 arg3)
  : m_type(type), m_arg1(arg1), m_arg2(arg2), m_arg3(arg3), m_data(data) { }


Event::Event(wxInt32 type, wxInt32 arg1, const wxString& data, wxInt8 arg2, wxInt8 arg3)
  : m_type(type), m_arg1(arg1), m_arg2(arg2), m_arg3(arg3), m_data(MemBuf(data)) { }


Event::Event(MemBuf* data) {
  if (unserialize(data, "iibbM", &m_type, &m_arg1, &m_arg2, &m_arg3, &m_data) == 0) {
    *this = Event();
  }
}


MemBuf Event::serialize() const {
  return ::serialize("iibbM", m_type, m_arg1, m_arg2, m_arg3, &m_data);
}


bool Event::test() {
  Event a = Event::Chat(wxT("TESTING BLAH BLAH"), 2);
  MemBuf mb = a.serialize();
  Event b(&mb);

  if (a.type() != b.type() || a.arg1() != b.arg1() || a.arg2() != b.arg2() ||
      a.arg3() != b.arg3() || a.data() != b.data()) {
    return false;
  }
  return true;
}


Event Event::Error(const wxString& msg)
{ return Event(EVENT_ERROR, 0, msg); }


Event Event::Chat(const wxString& msg, wxInt8 from)
{ return Event(EVENT_CHAT, from, msg); }


Event Event::Name(const wxString& msg, wxInt8 gender)
{ return Event(EVENT_NAME, gender, msg); }


Event Event::Welcome(wxInt8 client_no, const GameState& game)
{ return Event(EVENT_WELCOME, client_no, game.serialize()); }


Event Event::Join(wxInt8 client, const wxString& name)
{ return Event(EVENT_JOIN, client, name); }


Event Event::Leave(wxInt8 client, const wxString& reason)
{ return Event(EVENT_LEAVE, client, reason); }


Event Event::NewTurn(wxInt8 client, const GameState& game)
{ return Event(EVENT_NEWTURN, game.turn(), game.serialize(), client); }


Event Event::GameOver(const GameState& game)
{ return Event(EVENT_GAMEOVER, 0, game.serialize()); }


Event Event::Msg(const wxString& msg)
{ return Event(EVENT_MSG, 0, msg); }


Event Event::Msg(const wxChar* fmt, ...) {
  va_list ap;
  va_start(ap, fmt);
  Event e(EVENT_MSG, 0, wxString::FormatV(fmt, ap));
  va_end(ap);
  return e;
}


Event Event::Waiting(wxUint32 vec)
{ return Event(EVENT_WAITING, vec, wxT("")); }


Event Event::ClHands(wxInt8 left, wxInt8 right)
{ return Event(EVENT_CL_HANDS, 0, MemBuf(), left, right); }


// This is such an ugly hack. It makes me cry. (The string is a flag. :-( )
Event Event::SvHands(wxInt8 player, wxInt8 left, wxInt8 right, bool replace)
{ return Event(EVENT_SV_HANDS, player, MemBuf(replace ? wxT("x") : wxT("")), left, right); }


Event Event::Question(const wxString& question, wxInt8 n_answers, const wxString msgs[]) {
  MemBuf data;
  wxASSERT(n_answers > 0);
  data.append(question);
  for (int i = 0 ; i < n_answers ; i++) {
    data.append('\0');
    data.append(msgs[i]);
  }
  return Event(EVENT_QUESTION, 0, data);
}


Event Event::Answer(const wxString& question, wxInt32 index)
{ return Event(EVENT_ANSWER, index, question); }

