/* $Id: Dialogs.h,v 1.1.1.1 2008/02/25 12:26:54 dpt Exp $
 *
 * Dialogs.h: Dialog boxes. Woohoo.
 */

#ifndef __DIALOGS_H__
#define __DIALOGS_H__

#include "Spellcast.h"
#include <wx/spinctrl.h>


enum dialog_events {
  DLOG_OK = 200,
  DLOG_CANCEL,
};



class ServerDialog : public wxDialog {
 public:
  ServerDialog();
  ~ServerDialog();

  void OnOK(wxCommandEvent& event);
  void OnCancel(wxCommandEvent& event);

private:
  wxTextCtrl* sv_name;
  wxTextCtrl* sv_port;
  wxSpinCtrl* sv_maxp;

  DECLARE_EVENT_TABLE()
};


class ClientDialog : public wxDialog {
 public:
  ClientDialog();
  ~ClientDialog();

  void OnOK(wxCommandEvent& event);
  void OnCancel(wxCommandEvent& event);

private:
  wxTextCtrl* cl_name;
  wxTextCtrl* sv_addr;
  wxTextCtrl* sv_port;

  DECLARE_EVENT_TABLE()
};


class AboutDialog : public wxDialog {
 public:
  AboutDialog();
  void OnOK(wxCommandEvent& event);

  DECLARE_EVENT_TABLE()
};


class PrefsDialog : public wxDialog {
 public:
  PrefsDialog(bool first_time);
  ~PrefsDialog();

  void OnOK(wxCommandEvent& event);
  void OnCancel(wxCommandEvent& event);

private:
  wxTextCtrl* m_name;
  wxRadioBox* m_gender;

  DECLARE_EVENT_TABLE()
};


#endif   // __DIALOGS_H__

