/* $Id: Util.h,v 1.7 2008/05/04 09:19:51 dpt Exp $
 *
 * Util.h: Miscellaneous useful functions.
 */

#ifndef __UTIL_H__
#define __UTIL_H__

#include "MemBuf.h"
#include <wx/socket.h>

#define PACKAGE   "wxSpellcast"

// Irritating: post-2.8.7 wxWidgets has c_str() return some lame
// intermediate object, not a char*, so gcc barfs when you try to pass
// it through variadic functions, like SCApp::log(). Thanks for breaking
// my code, guys!
#define C_STR(x)  ((x).c_str().AsChar())


// These functions get called by the serialize() methods of other classes.

MemBuf serialize(const char* fmt, ...);
void serialize_string_array(wxString array[], wxUint32 howmany, MemBuf* output);
wxUint32 unserialize(MemBuf* input, const char* fmt, ...);
wxUint32 unserialize_string_array(const wxUint8* input, wxUint32 input_len,
				   wxString array[], wxUint32 howmany);
bool test_serialize();


// Preferences stuff:

inline wxString GET_SERVER_NAME() {
  return wxConfig::Get()->Read(wxT("server_name"), wxT("Meat Shack"));
}

inline wxString GET_SERVER_ADDR() {
  return wxConfig::Get()->Read(wxT("server_addr"), wxT(""));
}

inline wxString GET_CLIENT_NAME() {
  return wxConfig::Get()->Read(wxT("player_name"), wxT("Cheese Bomb"));
}

const wxUint16 DEFAULT_PORT = 41097;
inline wxUint16 GET_SERVER_PORT() {
  return wxConfig::Get()->Read(wxT("server_port"), DEFAULT_PORT);
}

inline wxUint16 GET_MY_SERVER_PORT() {
  return wxConfig::Get()->Read(wxT("my_server_port"), DEFAULT_PORT);
}

const unsigned int MAX_PLAYERS = 8;
inline unsigned int GET_MAX_PLAYERS() {
  return wxConfig::Get()->Read(wxT("max_players"), MAX_PLAYERS);
}

inline unsigned int GET_MY_GENDER() {
  return wxConfig::Get()->Read(wxT("my_gender"), (long) 0);
}

inline wxString GET_LOG_DIR() {
  return wxConfig::Get()->Read(wxT("log_dir"), wxGetCwd());
}


// Miscellaneous functions, didn't know where else to put them.

const wxChar* socket_error_string(wxSocketBase* sock);
const wxChar* ip_peer_name(wxIPV4address addr);

// This is to work around some heinous bugs in wxWindows' wxString class
// when the string has NUL characters in it. Sigh.
// FIXME: Are these still necessary in 2.8? Hopefully not.
int StringFind(const wxString& str, char ch);
void StringRemove(wxString& str, size_t pos, size_t len);
// I can't believe I had to write this myself.
wxString StringReverse(const wxString& str);

wxString escaped_string(const wxString& str);
wxSize find_max_widget_size(wxSize a, wxSize b);
void fail(const wxChar* fmt, ...);


// FIXME replace these with wxWhatever versions
#define REQUIRE(x)  if (!(x)) {  \
  fail(wxT("Requirement failed at %s, line %d."), __FILE__, __LINE__); \
} else {}
#define FAIL()         fail(wxT("Can't happen! (%s line %d)"), __FILE__, __LINE__)
#define FAIL_MSG(msg)  fail(wxT(msg " (%s line %d)"), __FILE__, __LINE__)


#endif   // __UTIL_H__

