/* $Id: Spellcast.h,v 1.5 2008/05/04 09:19:51 dpt Exp $
 *
 * Spellcast.h: A global include file that includes lots of useful stuff. Yeah.
 */

#ifndef __SPELLCAST_H__
#define __SPELLCAST_H__

#include "Images.h"
#include "MemBuf.h"
#include "Frames.h"
#include "Rules.h"
#include <wx/socket.h>
#include <wx/dynarray.h>


class Connection;
WX_DEFINE_ARRAY(Connection*, ConnArray);

class Server : public wxEvtHandler {
 public:
  static bool Open(const wxString& sv_name, int max_players, wxUint16 port);
  ~Server();

  bool is_full() const;
  inline const GameState& state() const { return *m_rules; }
  void send_event(int client_no, const Event& ev);
  void broadcast(const Event& ev);
  wxUint16 port() const;
  inline void start_game() { m_rules->start_game(); }

  void OnClientEvent(wxSocketEvent& event);
  void OnServerEvent(wxSocketEvent& event);

 private:
  Server(const wxString& sv_name, int max_players, wxUint16 port);
  void _sanity_check() const;
  void _send_data(Connection* conn, const MemBuf& data);
  void _clean_suppliant_list();
  bool _eat_some_data(Connection* conn);
  bool _read_event(Connection* conn, Event& ev);
  Connection* _socket_to_conn(wxSocketBase* sock);
  int  _conn_to_client(Connection* conn);
  int  _next_client_slot();
  void _remove_connection(Connection* conn, const wxString& reason = wxT(""));
  void _do_turn();

  Rules*      m_rules;
  wxSocketServer* m_sock;
  Connection* m_clients[ MAX_PLAYERS ];
  ConnArray   m_suppliants;

  DECLARE_EVENT_TABLE()
};


class Client : public wxEvtHandler {
 public:
  static bool Open(const wxString& name, wxIPV4address addr);
  ~Client();

  inline bool is_connected() const { return m_sock != NULL && m_sock->IsConnected(); }
  inline bool is_logged_in() const {
    return is_connected() && m_state != NULL &&
      m_state->game_state() != NO_GAME_YET;
  }
  inline const GameState& state() const { return *m_state; }
  void send_event(const Event& ev);
  void send_gestures();
  void OnSockEvent(wxSocketEvent& event);

 private:
  Client(const wxString& name, wxIPV4address addr);
  bool _read_event(Event& ev);
  bool _eat_some_data();
  void _update_state(Event& ev);

  GameState*      m_state;
  wxSocketClient* m_sock;
  wxIPV4address   m_peer;
  MemBuf          m_buf;
  bool            m_dead;

  DECLARE_EVENT_TABLE()
};


class SCFrame : public wxFrame {
 public:
  static void Open(const wxString& title, const wxSize& size);
  ~SCFrame();

  void start_server();
  void start_client();
  void set_connected(bool is_connected);
  void turn_started();
  void game_over();
  void log(const wxChar* fmt, ...);
  void log(const wxString& str);
  void log_hidden(const wxChar* fmt, ...);
  void log_hidden(const wxString& str);
  void refresh();
  void show_question(const Question& q);
  void clear_questions();

  void OnAbout(wxCommandEvent& event);
  void OnPrefs(wxCommandEvent& event);
  void OnServer(wxCommandEvent& event);
  void OnClient(wxCommandEvent& event);
  void OnDiscon(wxCommandEvent& event);
  void OnExit(wxCommandEvent& event);
  void OnCut(wxCommandEvent& event);
  void OnCopy(wxCommandEvent& event);
  void OnPaste(wxCommandEvent& event);
  void OnSelectAll(wxCommandEvent& event);
  void OnSaveLog(wxCommandEvent& event);
  void OnChat(wxCommandEvent& event);
  void OnSpellList(wxCommandEvent& event);
  void OnSpellListDismiss();
  void OnEndButton(wxCommandEvent& event);
  void SetStatus(const wxString& status);
  void ShowStatus(wxMenuEvent& event);
  void OnMouse(wxMouseEvent& event);
  void OnListBox(wxCommandEvent& event);
  void OnKeyboard(wxKeyEvent& event);

 private:
  SCFrame(const wxString& title, const wxSize& size);
  wxPanel*       m_panel;
  wxTextCtrl*    m_text;
  wxTextCtrl*    m_input;
  wxMenu*        m_file_menu;
  wxString       m_status;
  GestureWindow* m_gamewin;
  wxBoxSizer*    m_gamesizer;
  wxButton*      m_end_btn;
  wxButton*      m_spell_btn;
  SpellWindow*   m_spellwin;
  ArenaList*     m_arenawin;
  wxStaticText*  m_qtext[ MAX_QUESTIONS ];
  wxComboBox*    m_qboxes[ MAX_QUESTIONS ];
  wxString       m_log;

  DECLARE_EVENT_TABLE()
};


class SCApp : public wxApp {
 public:
  virtual bool OnInit();
  virtual int  OnExit();
};
DECLARE_APP(SCApp)


// Global variables shared between all of these classes.

extern SCFrame* g_window;
extern Client* g_client;
extern Server* g_server;
extern Images* g_images;
extern wxString g_initial[NUMBER_OF_HANDS];


#endif   // __SPELLCAST_H__
