/* $Id: Messages.h,v 1.1.1.1 2008/02/25 12:26:54 dpt Exp $
 *
 * Messages.h: Functions that generate custom Event::Msg objects.
 */

#ifndef __MESSAGES_H__
#define __MESSAGES_H__

#include "GameData.h"


// GameState.cpp
Event msg_o_game_start(Player* p);
Event msg_s_game_start();
Event msg_a_amnesia_hit(Player* p);
Event msg_a_confusion_hit(Player* p, int hand);
Event msg_a_charm_person_hit(Player* p);
Event msg_a_fear_miss(Player* p);
Event msg_a_fear_hit_1(Player* p, int hand);
Event msg_a_fear_hit_2(Player* p);
Event msg_a_paralysis_hit(Player* p);
Event msg_o_surrendered(Player* p);
Event msg_s_surrendered();


// GS_Turn.cpp
Event msg_a_sole_survivor(Player* p);
Event msg_a_win_by_surrender(Player* p, Player* stiff = NULL);
Event msg_a_who_won(Player* p);
Event msg_a_draw_game();
Event msg_a_everyone_dead();
Event msg_a_nobody_left(Player* p);
Event msg_a_survivors_surrender();
Event msg_a_everyone_surrenders();
Event msg_o_start_haste(Being* b);
Event msg_s_start_haste();
Event msg_o_continue_haste(Being* b);
Event msg_s_continue_haste();
Event msg_o_end_haste(Being* b);
Event msg_s_end_haste();
Event msg_o_start_timestop(Being* b);
Event msg_s_start_timestop();
Event msg_o_end_timestop(Being* b);
Event msg_s_end_timestop();
Event msg_o_disease_progress(Being* b, int time);
Event msg_s_disease_progress(int time);
Event msg_o_poison_progress(Being* b, int time);
Event msg_s_poison_progress(int time);
Event msg_o_has_died(Being* b);
Event msg_s_has_died();
Event msg_o_permanency_done(Player* p);
Event msg_s_permanency_done();
Event msg_o_delayed_effect_done(Player* p);
Event msg_s_delayed_effect_done();
Event msg_o_visibility_miss(Player* c, Being* t, DoneSpell* sp);
Event msg_s_visibility_miss(Being* t, DoneSpell* sp);
Event msg_t_visibility_miss(Player* c, DoneSpell* sp);
Event msg_a_dispel_magic();
Event msg_a_dispelled(DoneSpell* sp);
Event msg_o_countered(Being* b, DoneSpell* sp);
Event msg_s_countered(DoneSpell* sp);
Event msg_s_made_permanent(DoneSpell* sp);
Event msg_o_made_delayed(Player* p, DoneSpell* sp);
Event msg_s_made_delayed(DoneSpell* sp);
Event msg_o_lb2_failed(Player* p);
Event msg_s_lb2_failed();
Event msg_o_two_mirrors(Player* p, Being* b, DoneSpell* sp);
Event msg_s_two_mirrors(Being* b, DoneSpell* sp);
Event msg_t_two_mirrors(Player* p, DoneSpell* sp);
Event msg_o_mirrored(Player* p, Being* b, DoneSpell* sp);
Event msg_s_mirrored(Being* b, DoneSpell* sp);
Event msg_t_mirrored(Player* p, DoneSpell* sp);
Event msg_o_bounce_countered(Being* b, DoneSpell* sp);
Event msg_s_bounce_countered(DoneSpell* sp);
Event msg_o_dispel_counter(Being* b);
Event msg_s_dispel_counter();
Event msg_o_dispel_mirror(Being* b);
Event msg_s_dispel_mirror();
Event msg_o_got_counter(Being* b);
Event msg_s_got_counter();
Event msg_o_got_mirror(Being* b);
Event msg_s_got_mirror();
Event msg_o_counter_mirror(Being* b);
Event msg_s_counter_mirror();
Event msg_a_dispel_creature(Being* b);
Event msg_a_dispel_corpse(Being* b);


// GS_Spells.cpp
Event msg_o_summon_monsters(Player* p, int type, int howmany);
Event msg_s_summon_monsters(int type, int howmany);
Event msg_o_summon_fire_el(Player* p);
Event msg_o_summon_ice_el(Player* p);
Event msg_s_summon_fire_el();
Event msg_s_summon_ice_el();
Event msg_a_elementals_merge(int type, int howmany);
Event msg_a_elementals_fight();
Event msg_a_elemental_storm_1(int el_type, int storm_type);
Event msg_a_elemental_storm_2(int el_type, int storm_type);
Event msg_a_elementals_kill_storm(int storm_type);
Event msg_a_storms_fight();
Event msg_a_storms_kill_elemental(int el_type);
Event msg_a_storms_and_elementals();
Event msg_a_fire_el_resisted(Creature* c);
Event msg_a_ice_el_resisted(Creature* c);
Event msg_a_ice_el_fireballed(Creature* c);
Event msg_a_spell_stress(Being* b, int spell);
Event msg_a_rmench_stress(Creature* c);
Event msg_o_fod_raise_cancel(Being* b);
Event msg_s_fod_raise_cancel();
Event msg_o_fb_storm_cancel(Being* b);
Event msg_s_fb_storm_cancel();
Event msg_o_perm_mind_cancel(Being* b, int spell, int perm_spell);
Event msg_s_perm_mind_cancel(int spell, int perm_spell);
Event msg_o_mind_cancel(Being* b, int spell[], int n_spells);
Event msg_s_mind_cancel(int spell[], int n_spells);
Event msg_o_got_resist_heat(Being* b);
Event msg_s_got_resist_heat();
Event msg_o_got_resist_cold(Being* b);
Event msg_s_got_resist_cold();
Event msg_o_more_resist_heat(Being* b);
Event msg_s_more_resist_heat();
Event msg_o_more_resist_cold(Being* b);
Event msg_s_more_resist_cold();
Event msg_o_got_prot_evil(Being* b);
Event msg_s_got_prot_evil();
Event msg_o_more_prot_evil(Being* b);
Event msg_s_more_prot_evil();
Event msg_o_fade_prot_evil_3(Being* b);
Event msg_s_fade_prot_evil_3();
Event msg_o_fade_prot_evil_2(Being* b);
Event msg_s_fade_prot_evil_2();
Event msg_o_fade_prot_evil_1(Being* b);
Event msg_s_fade_prot_evil_1();
Event msg_o_mind_curl(Being* b, int spell);
Event msg_s_mind_curl(int spell);
Event msg_o_hand_curl(Being* b, int spell, int hand);
Event msg_s_hand_curl(int spell, int hand);
Event msg_o_mind_fail(Being* b, int spell);
Event msg_s_mind_fail(int spell);
Event msg_a_charm_monster(Player* p, Being* b);
Event msg_o_mind_afflicted(Being* b, int spell);
Event msg_s_mind_afflicted(int spell);
Event msg_o_anti_rmench_cancel(Being* b);
Event msg_s_anti_rmench_cancel();
Event msg_o_antispell_hit(Being* b);
Event msg_s_antispell_hit();
Event msg_a_antispell_miss(Being* b);
Event msg_o_delay_rmench_cancel(Being* b);
Event msg_s_delay_rmench_cancel();
Event msg_o_delay_hit(Being* b);
Event msg_s_delay_hit();
Event msg_a_delay_miss(Being* b);
Event msg_o_perm_rmench_cancel(Being* b);
Event msg_s_perm_rmench_cancel();
Event msg_o_perm_hit(Being* b);
Event msg_s_perm_hit();
Event msg_a_perm_miss(Being* b);
Event msg_o_blind_hit(Being* b);
Event msg_s_blind_hit();
Event msg_o_blind_fades(Being* b);
Event msg_s_blind_fades();
Event msg_o_blind_still(Being* b);
Event msg_s_blind_still();
Event msg_o_charmed_still(Being* b);
Event msg_s_charmed_still();
Event msg_a_charmed_still(Creature* c, Being* b);
Event msg_s_paralyzed_still(int hand);
Event msg_o_paralyzed_still(Being* b, int hand);
Event msg_a_paralyzed_still(Creature* c);
Event msg_o_invis_hit(Being* b);
Event msg_s_invis_hit();
Event msg_o_invis_fades(Being* b);
Event msg_s_invis_fades();
Event msg_o_invis_still(Being* b);
Event msg_s_invis_still();
Event msg_o_rmench_hit(Being* b);
Event msg_s_rmench_hit();
Event msg_o_dispel_mind(Being* b, int spell);
Event msg_s_dispel_mind(int spell);
Event msg_o_dispel_heat(Being* b);
Event msg_s_dispel_heat();
Event msg_o_dispel_cold(Being* b);
Event msg_s_dispel_cold();
Event msg_o_dispel_disease(Being* b);
Event msg_s_dispel_disease();
Event msg_o_dispel_poison(Being* b);
Event msg_s_dispel_poison();
Event msg_o_dispel_delay(Being* b);
Event msg_s_dispel_delay();
Event msg_o_dispel_stored(Player* p);
Event msg_s_dispel_stored(Player* p);
Event msg_o_dispel_perm(Being* b);
Event msg_s_dispel_perm();
Event msg_o_dispel_prot(Being* b);
Event msg_s_dispel_prot();
Event msg_o_dispel_haste(Being* b);
Event msg_s_dispel_haste();
Event msg_o_cancel_haste(Being* b);
Event msg_s_cancel_haste();
Event msg_o_cancel_timestop(Being* b);
Event msg_s_cancel_timestop();
Event msg_o_dispel_invis(Being* b);
Event msg_s_dispel_invis();
Event msg_o_dispel_blind(Being* b);
Event msg_s_dispel_blind();
Event msg_o_stabs_miss(Being* b, int howmany);
Event msg_s_stabs_miss(int howmany);
Event msg_o_stabs_hit(Being* b, int howmany);
Event msg_s_stabs_hit(int howmany);
Event msg_o_missiles_miss(Being* b, int howmany);
Event msg_s_missiles_miss(int howmany);
Event msg_o_missiles_hit(Being* b, int howmany);
Event msg_s_missiles_hit(int howmany);
Event msg_o_cause_light_hit(Being* b, int howmany);
Event msg_s_cause_light_hit(int howmany);
Event msg_o_cause_heavy_hit(Being* b, int howmany);
Event msg_s_cause_heavy_hit(int howmany);
Event msg_o_lightning_hit(Being* b, int howmany);
Event msg_s_lightning_hit(int howmany);
Event msg_o_fireball_resist(Being* b, int howmany);
Event msg_s_fireball_resist(int howmany);
Event msg_o_fireball_hit(Being* b, int howmany);
Event msg_s_fireball_hit(int howmany);
Event msg_o_counter_storm(Being* b, int storm_type);
Event msg_s_counter_storm(int storm_type);
Event msg_o_fire_storm_resist(Being* b);
Event msg_s_fire_storm_resist();
Event msg_o_ice_storm_resist(Being* b);
Event msg_s_ice_storm_resist();
Event msg_o_storm_hit(Being* b, int storm_type);
Event msg_s_storm_hit(int storm_type);
Event msg_o_fod_hit(Being* b);
Event msg_s_fod_hit();
Event msg_o_cure_light(Being* b, int howmany);
Event msg_s_cure_light(int howmany);
Event msg_o_cure_heavy(Being* b, int howmany);
Event msg_s_cure_heavy(int howmany);
Event msg_o_raise_alive(Being* b, int howmany);
Event msg_s_raise_alive(int howmany);
Event msg_o_raise_dead(Being* b);
Event msg_s_raise_dead();
Event msg_o_all_healed(Being* b);
Event msg_s_all_healed();



// GS_Creatures.cpp
Event msg_o_arena_full(Player* p);
Event msg_s_arena_full();
Event msg_a_monster_paralyzed(Creature* c);
Event msg_a_monster_amnesia_1(Creature* c, Being* t);
Event msg_a_monster_amnesia_2(Creature* c);
Event msg_a_monster_confused(Creature* c, Being* t);
Event msg_a_monster_not_self(Creature* c);
Event msg_o_monster_cant_see(Creature* c, Being* t);
Event msg_s_monster_cant_see(Creature* c);
Event msg_o_monster_blocked(Creature* c, Being* t);
Event msg_s_monster_blocked(Creature* c);
Event msg_o_monster_fireblock(Creature* c, Being* t);
Event msg_s_monster_fireblock(Creature* c);
Event msg_o_monster_firethrow(Creature* c, Being* t);
Event msg_s_monster_firethrow(Creature* c);
Event msg_o_monster_iceblock(Creature* c, Being* t);
Event msg_s_monster_iceblock(Creature* c);
Event msg_o_monster_icethrow(Creature* c, Being* t);
Event msg_s_monster_icethrow(Creature* c);
Event msg_o_monster_attacks(Creature* c, Being* t);
Event msg_s_monster_attacks(Creature* c);



#endif   // __MESSAGES_H__
