/* $Id: Frames.h,v 1.7 2008/04/16 04:22:55 dpt Exp $
 *
 * Frames.h: Code for several custom frames that we have to pop up.
 */

#ifndef __FRAMES_H__
#define __FRAMES_H__

#include "GameData.h"


class PickWindow : public wxFrame {
 public:
  PickWindow(int hand, int current_gesture, wxPoint pos);
  int get_gesture(wxPoint screen_coords);
  ~PickWindow();
  void OnPaint(wxPaintEvent& event);
  void OnDrag(wxPoint location);
  void OnFocus(wxFocusEvent& WXUNUSED(event)) { Navigate(); }
  inline int hand() const { return m_hand; }

 private:
  wxPoint _get_position(wxPoint pos, int gesture);
  wxPen* m_grey;
  wxPen* m_black;
  int m_hand;
  int m_gesture;

  DECLARE_EVENT_TABLE()
};


class LogWindow : public wxTextCtrl {
 public:
  LogWindow(wxWindow* parent, wxTextCtrl* input, const wxPoint& pos = wxDefaultPosition,
	    const wxSize& size = wxDefaultSize);
  void LogWindow::OnKeyboard(wxKeyEvent& event);
  void AppendText(const wxString& text);

 private:
  wxTextCtrl* m_input;
  DECLARE_EVENT_TABLE()
};


class GestureWindow : public wxScrolledWindow {
 public:
  GestureWindow(wxWindow* parent);
  void OnDraw(wxDC& dc);
  void OnMouse(wxMouseEvent& event);
  void OnFocus(wxFocusEvent& WXUNUSED(event)) { Navigate(); }
  inline bool Clickable() { return m_click; }
  inline void SetClickable(bool foo) { m_click = foo; }

 private:
  void _DrawPlayer(wxDC& dc, const Player* player, wxPoint where);
  int _clicked_on_hand(wxPoint pt);

  PickWindow* m_picker;
  wxRect      m_boxes[ NUMBER_OF_HANDS ];
  bool        m_click;

  DECLARE_EVENT_TABLE()
};


class SpellWindow : public wxFrame {
 public:
  SpellWindow(wxBitmap* img);
  ~SpellWindow();
  void OnPaint(wxPaintEvent& event);

 private:
  wxBitmap* m_bitmap;

  DECLARE_EVENT_TABLE()
};


class ArenaList : public wxListBox {
 public:
  ArenaList(wxWindow* parent, int id);
  void UpdateList();
  void UpdateList(const GameState& state);
  void OnMouse(wxMouseEvent& WXUNUSED(event)) { }
  void OnFocus(wxFocusEvent& WXUNUSED(event)) { Navigate(); }

 private:
  DECLARE_EVENT_TABLE()
};


#endif   // __FRAMES_H__
