// Event.h: Events are communication packets between the clients and server.

#ifndef __EVENT_H__
#define __EVENT_H__

#include "Util.h"


enum event_types {
  EVENT_BOGUS,
  EVENT_ERROR,
  EVENT_CHAT,
  EVENT_NAME,
  EVENT_WELCOME,
  EVENT_JOIN,
  EVENT_LEAVE,
  EVENT_NEWTURN,
  EVENT_GAMEOVER,
  EVENT_MSG,
  EVENT_WAITING,
  EVENT_CL_HANDS,
  EVENT_SV_HANDS,
  EVENT_QUESTION,
  EVENT_ANSWER,
  NUMBER_OF_EVENT_TYPES
};

extern const char* event_type_list[ NUMBER_OF_EVENT_TYPES ];


class GameState;

class Event {
 public:
  Event();
  Event(wxInt32 type, wxInt32 arg1 = 0, const MemBuf& data = MemBuf(), wxInt8 arg2 = 0, wxInt8 arg3 = 0);
  Event(wxInt32 type, wxInt32 arg1 = 0, const wxString& data = wxT(""), wxInt8 arg2 = 0, wxInt8 arg3 = 0);
  Event(MemBuf* data);
  MemBuf serialize() const;

  static bool test();
  static Event Error(const wxString& msg);
  static Event Chat(const wxString& msg, wxInt8 from);
  static Event Name(const wxString& msg, wxInt8 gender);
  static Event Welcome(wxInt8 client_no, const GameState& game);
  static Event Join(wxInt8 client, const wxString& name);
  static Event Leave(wxInt8 client, const wxString& reason);
  static Event NewTurn(wxInt8 client, const GameState& game);
  static Event GameOver(const GameState& game);
  static Event Msg(const wxString& msg);
  static Event Msg(const wxChar* fmt, ...);
  static Event Waiting(wxUint32 vec);
  static Event ClHands(wxInt8 left, wxInt8 right);
  static Event SvHands(wxInt8 player, wxInt8 left, wxInt8 right, bool replace = false);
  static Event Question(const wxString& question, wxInt8 n_answers, const wxString msgs[]);
  static Event Answer(const wxString& question, wxInt32 index);

  inline wxInt32 type() const { return m_type; }
  inline wxInt32 arg1() const { return m_arg1; }
  inline wxInt8 arg2() const { return m_arg2; }
  inline wxInt8 arg3() const { return m_arg3; }
  inline MemBuf* data() { return &m_data; }
  inline bool is_ok() const { return m_type != EVENT_BOGUS; }

 private:
  wxInt32        m_type;
  wxInt32        m_arg1;
  wxInt8         m_arg2;
  wxInt8         m_arg3;
  MemBuf         m_data;
};

const int EVENT_HEADER_LEN = 11;


#endif   // __EVENT_H__
