/* $Id: Dialogs.cpp,v 1.2 2008/04/12 21:20:43 dpt Exp $
 *
 * Dialogs.cpp: Dialog boxes. Woohoo.
 */

#include "Dialogs.h"

static wxString portvalue;


ServerDialog::ServerDialog()
  : wxDialog(g_window, -1, wxT("Start New Server"), wxDefaultPosition,
	      wxDefaultSize, wxDEFAULT_DIALOG_STYLE)  {

  sv_name = new wxTextCtrl(this, -1, GET_SERVER_NAME(), wxDefaultPosition, wxSize(300, -1));
  sv_name->SetMaxLength(127);
  portvalue.Printf(wxT("%d"), GET_MY_SERVER_PORT());
  sv_port = new wxTextCtrl(this, -1, portvalue, wxDefaultPosition, wxDefaultSize, 0,
			    wxTextValidator(wxFILTER_NUMERIC, &portvalue));
  sv_port->SetMaxLength(5);
  sv_maxp = new wxSpinCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS,
			   2, MAX_PLAYERS, GET_MAX_PLAYERS());

  // The following line looks stupid, I know, but it actually works
  // around a bug with wxGTK's spinner not displaying its initial value.
  // FIXME: Is this bug still extant?
  sv_maxp->SetValue(sv_maxp->GetValue());  

  wxFlexGridSizer* inputsizer = new wxFlexGridSizer(2, 2, 2, 2);
  inputsizer->Add(new wxStaticText(this, -1, wxT("Server name:")), 0, wxALL, 4);
  inputsizer->Add(sv_name, 1, wxALL, 4);
  inputsizer->Add(new wxStaticText(this, -1, wxT("Server port:")), 0, wxALL, 4);
  inputsizer->Add(sv_port, 1, wxALL, 4);
  inputsizer->Add(new wxStaticText(this, -1, wxT("Max players:")), 0, wxALL, 4);
  inputsizer->Add(sv_maxp, 1, wxALL, 4);

  wxBoxSizer* buttonsizer = new wxBoxSizer(wxHORIZONTAL);
  buttonsizer->Add(new wxStaticText(this, -1, wxT(" ")), 1, wxALL, 4);
  buttonsizer->Add(new wxButton(this, DLOG_CANCEL, wxT("Cancel")), 0, wxALIGN_RIGHT | wxALL, 4);
  wxButton* start = new wxButton(this, DLOG_OK, wxT("Start Server"));
  buttonsizer->Add(start, 0, wxALIGN_RIGHT | wxALL, 4);
  start->SetDefault();

  wxBoxSizer* topsizer = new wxBoxSizer(wxVERTICAL);
  topsizer->Add(inputsizer, 0, wxEXPAND | wxALL, 2);
  topsizer->Add(buttonsizer, 1, wxEXPAND | wxALL, 2);
  SetAutoLayout(TRUE);
  SetSizer(topsizer);
  topsizer->Fit(this);
  topsizer->SetSizeHints(this);
  SetReturnCode(0);
}


ServerDialog::~ServerDialog() {
  delete sv_name;
  delete sv_port;
}


void ServerDialog::OnOK(wxCommandEvent& WXUNUSED(event)) {
  wxASSERT(g_server == NULL);
  wxASSERT(g_client == NULL);

  if (!(Validate() && TransferDataFromWindow())) {
    fprintf(stderr, "validation failed for server dialog!\n");
    EndModal(0);
    return;
  }

  if (sv_name->GetValue().Length() == 0) {
    wxMessageBox(wxT("Bogus server name!"), wxT("Bogus!"), wxICON_EXCLAMATION | wxOK);
    EndModal(0);
    return;
  }
  wxConfig::Get()->Write(wxT("server_name"), sv_name->GetValue());

  long l;
  if (sv_port->GetValue().Length() == 0 || sv_port->GetValue().ToLong(&l) == false ||
      l <= 0 || l > 65535) {
    wxMessageBox(wxT("Bogus server port!"), wxT("Bogus!"), wxICON_EXCLAMATION | wxOK);
    EndModal(0);
    return;
  }
  wxConfig::Get()->Write(wxT("my_server_port"), l);

  if (sv_maxp->GetValue() < 2 || sv_maxp->GetValue() > (int) MAX_PLAYERS) {
    wxMessageBox(wxT("Bogus max players!"), wxT("Bogus!"), wxICON_EXCLAMATION | wxOK);
    EndModal(0);
    return;
  }
  wxConfig::Get()->Write(wxT("max_players"), (long) sv_maxp->GetValue());

  EndModal(1);
}


void ServerDialog::OnCancel(wxCommandEvent& WXUNUSED(event)) {
  EndModal(0);
}


BEGIN_EVENT_TABLE(ServerDialog, wxDialog)
  EVT_BUTTON(DLOG_OK,     ServerDialog::OnOK)
  EVT_BUTTON(DLOG_CANCEL, ServerDialog::OnCancel)
END_EVENT_TABLE()



ClientDialog::ClientDialog()
  : wxDialog(g_window, -1, wxT("Join Game"), wxDefaultPosition, wxDefaultSize,
	      wxDEFAULT_DIALOG_STYLE)  {

  sv_addr = new wxTextCtrl(this, -1, GET_SERVER_ADDR(), wxDefaultPosition, wxSize(300, -1));
  sv_addr->SetMaxLength(127);
  portvalue.Printf(wxT("%d"), GET_SERVER_PORT());
  sv_port = new wxTextCtrl(this, -1, portvalue, wxDefaultPosition, wxDefaultSize, 0,
			    wxTextValidator(wxFILTER_NUMERIC, &portvalue));
  sv_port->SetMaxLength(5);

  wxFlexGridSizer* inputsizer = new wxFlexGridSizer(2, 2, 2, 2);
  inputsizer->Add(new wxStaticText(this, -1, wxT("Server address:")), 0, wxALL, 4);
  inputsizer->Add(sv_addr, 1, wxALL, 4);
  inputsizer->Add(new wxStaticText(this, -1, wxT("Server port:")), 0, wxALL, 4);
  inputsizer->Add(sv_port, 1, wxALL, 4);

  wxBoxSizer* buttonsizer = new wxBoxSizer(wxHORIZONTAL);
  buttonsizer->Add(new wxStaticText(this, -1, wxT(" ")), 1, wxALL, 4);
  buttonsizer->Add(new wxButton(this, DLOG_CANCEL, wxT("Cancel")), 0, wxALIGN_RIGHT | wxALL, 4);
  wxButton* join = new wxButton(this, DLOG_OK, wxT("Join Game"));
  join->SetDefault();
  buttonsizer->Add(join, 0, wxALIGN_RIGHT | wxALL, 4);

  wxBoxSizer* topsizer = new wxBoxSizer(wxVERTICAL);
  topsizer->Add(inputsizer, 0, wxEXPAND | wxALL, 2);
  topsizer->Add(buttonsizer, 0, wxEXPAND | wxALL, 2);
  SetAutoLayout(TRUE);
  SetSizer(topsizer);
  topsizer->Fit(this);
  topsizer->SetSizeHints(this);
  SetReturnCode(0);
}


ClientDialog::~ClientDialog() {
  delete sv_addr;
  delete sv_port;
}


void ClientDialog::OnOK(wxCommandEvent& WXUNUSED(event)) {
  wxASSERT(g_server == NULL);
  wxASSERT(g_client == NULL);

  if (!(Validate() && TransferDataFromWindow())) {
    fprintf(stderr, "validation failed for client dialog!\n");
    EndModal(0);
    return;
  }

  long l;
  if (sv_port->GetValue().Length() == 0 || sv_port->GetValue().ToLong(&l) == false ||
      l > 65535 || l <= 0) {
    wxMessageBox(wxT("Bogus server port!"), wxT("Bogus!"), wxICON_EXCLAMATION | wxOK);
    EndModal(0);
    return;
  }

  wxIPV4address addr;
  if (sv_addr->GetValue().Length() == 0 ||
      addr.Hostname(sv_addr->GetValue()) == false) {
    wxMessageBox(wxT("Bogus hostname!"), wxT("Bogus!"), wxICON_EXCLAMATION | wxOK);
    EndModal(0);
    return;
  }

  wxConfig::Get()->Write(wxT("server_addr"), sv_addr->GetValue());
  wxConfig::Get()->Write(wxT("server_port"), l);

  EndModal(1);
}


void ClientDialog::OnCancel(wxCommandEvent& WXUNUSED(event)) {
  EndModal(0);
}


BEGIN_EVENT_TABLE(ClientDialog, wxDialog)
  EVT_BUTTON(DLOG_OK,     ClientDialog::OnOK)
  EVT_BUTTON(DLOG_CANCEL, ClientDialog::OnCancel)
END_EVENT_TABLE()



AboutDialog::AboutDialog()
  : wxDialog(g_window, -1, wxT("About " PACKAGE), wxDefaultPosition,
	     wxDefaultSize, wxDEFAULT_DIALOG_STYLE)  {

  wxStaticBitmap* icon = new wxStaticBitmap(this, -1, g_images->get_icon());
  wxFlexGridSizer* textsizer = new wxFlexGridSizer(2, 2, 2, 2);
  textsizer->Add(icon, 0, wxALL, 2);
  textsizer->Add(new wxStaticText(this, -1, wxT(PACKAGE " " VERSION "\n" RELEASE_DATE)),
		 0, wxALL, 2);
  textsizer->Add(new wxStaticText(this, -1, wxT(" ")), 0, wxALL, 2);
  textsizer->Add(new wxStaticText(this, -1, wxT("By Dennis Taylor <dennis@funkplanet.com>.\n\nBased on the X11 game \"spellcast\", by Andrew\nPlotkin, which was itself based on an original\ngame by Richard A. Bartle. This game and its\nsource code may be freely modified and\ndistributed for non-commercial use only.\n ")), 0, wxALL, 2);

  wxButton* ok = new wxButton(this, DLOG_OK, wxT("OK"));
  ok->SetDefault();

  wxBoxSizer* topsizer = new wxBoxSizer(wxVERTICAL);
  topsizer->Add(textsizer, 0, wxALL, 2);
  topsizer->Add(ok, 0, wxALIGN_CENTRE | wxALL, 4);
  SetAutoLayout(TRUE);
  SetSizer(topsizer);
  topsizer->Fit(this);
  topsizer->SetSizeHints(this);
}


void AboutDialog::OnOK(wxCommandEvent& WXUNUSED(event)) {
  EndModal(0);
}


BEGIN_EVENT_TABLE(AboutDialog, wxDialog)
  EVT_BUTTON(DLOG_OK, AboutDialog::OnOK)
END_EVENT_TABLE()



static const wxString _genders[ NUMBER_OF_GENDERS ] = {
  wxT("Male"), wxT("Female"), wxT("Neither"), wxT("Uncertain")
};

PrefsDialog::PrefsDialog(bool first_time)
  : wxDialog(g_window, -1, wxT("Preferences"), wxDefaultPosition,
	     wxDefaultSize, wxDEFAULT_DIALOG_STYLE)  {

  m_name = new wxTextCtrl(this, -1, GET_CLIENT_NAME());
  m_name->SetMaxLength(15);

  m_gender = new wxRadioBox(this, -1, wxT("Your wizard's gender"), wxDefaultPosition,
			    wxDefaultSize, NUMBER_OF_GENDERS, _genders);

  wxBoxSizer* buttonsizer = new wxBoxSizer(wxHORIZONTAL);
  if (!first_time) {
    buttonsizer->Add(new wxButton(this, DLOG_CANCEL, wxT("Cancel")), 0, wxALIGN_CENTRE | wxALL, 4);
  }
  wxButton* join = new wxButton(this, DLOG_OK, wxT("OK"));
  join->SetDefault();
  buttonsizer->Add(join, 0, wxALIGN_CENTRE | wxALL, 4);

  wxBoxSizer* topsizer = new wxBoxSizer(wxVERTICAL);
  topsizer->Add(new wxStaticText(this, -1, wxT("Your wizard's name:")), 0, wxEXPAND | wxALL, 4);
  topsizer->Add(m_name, 0, wxEXPAND | wxALL, 4);
  topsizer->Add(m_gender, 0, wxEXPAND | wxALL, 4);
  topsizer->Add(buttonsizer, 0, wxALIGN_CENTRE | wxEXPAND | wxALL, 4);
  SetAutoLayout(TRUE);
  SetSizer(topsizer);
  topsizer->Fit(this);
  topsizer->SetSizeHints(this);
}


PrefsDialog::~PrefsDialog() {
  delete m_name;
  delete m_gender;
}


void PrefsDialog::OnOK(wxCommandEvent& WXUNUSED(event)) {
  if (!(Validate() && TransferDataFromWindow())) {
    fprintf(stderr, "validation failed for client dialog!\n");
    return;
  }

  if (m_name->GetValue().Length() == 0) {
    wxMessageBox(wxT("Bogus player name!"), wxT("Bogus!"), wxICON_EXCLAMATION | wxOK);
    return;
  }

  wxConfig::Get()->Write(wxT("player_name"), m_name->GetValue());
  wxConfig::Get()->Write(wxT("my_gender"), (long) m_gender->GetSelection());
  EndModal(0);
}


void PrefsDialog::OnCancel(wxCommandEvent& WXUNUSED(event)) {
  EndModal(0);
}


BEGIN_EVENT_TABLE(PrefsDialog, wxDialog)
  EVT_BUTTON(DLOG_OK,     PrefsDialog::OnOK)
  EVT_BUTTON(DLOG_CANCEL, PrefsDialog::OnCancel)
END_EVENT_TABLE()
